﻿﻿/////////////////////////////////////
/////// MainWindow.xaml.cs
/////////////////////////////////////
/// 
/// Project „VerRoVer“ 
/// 
/// $Rev: 265 $: Revision of last commit
/// $Author: franke, keller $: 
 ///
/// Copyright 2019, Physikalisch-Technische Bundesanstalt, Braunschweig & Berlin

using System;
using System.Windows;
using System.Windows.Navigation;
using tracimPTB_VerRoVer;

namespace VerRoVerClientTool
{

    /// <summary>
    /// Logic of interaction for MainWindow.xaml</summary>
    public partial class MainWindow : Window
    {
        /// <summary>
        /// Instance of the SoftwareUnderTest class 
        /// </summary>
        private ClientTool mySoftwareUnderTest = new ClientTool();
        /// <summary>
        /// Instance of the results reffering to the public example data
        /// </summary>
        /// <value>This is needed as this demonstrature does not feature a best fit library</value>
        private DefaultResults myDefaultResults;
        /// <summary>
        /// Initialize the main window
        /// </summary>
        public MainWindow()
        {

            InitializeComponent();
            this.myDefaultResults = new DefaultResults();
            this.DataContext = this.mySoftwareUnderTest;
            this.btRequestTest.Focus();
            tbActualXML.Text = "Server request and response will be shown here ...";
            txtStatus.Text = ".";
        }


        private void Button_LoadData_Click(object sender, RoutedEventArgs e)
        {
            // Load test data from file
            //this.mySoftwareUnderTest.loadTest().Wait();
            this.mySoftwareUnderTest.loadTest();

            btSubmitResults.IsEnabled = false;
            if (this.mySoftwareUnderTest.success)
            {
                tbProcessID.Text = this.mySoftwareUnderTest.tracimTestMessage.process.key;
                tbOrderID.Text = this.mySoftwareUnderTest.tracimTestMessage.order.key;
                tbActualXML.Text = "Requested test data";
                txtStatus.Text = "Request successful.";
                this.btEvaluate.IsEnabled = true;
                this.btEvaluate.Focus();
                //this.mySoftwareUnderTest.loadFreeData = false;
                this.modeCheckBox.IsChecked = false; 
            }
            else
            {
                tbActualXML.Text = "Request failed with the following message ...";
                txtStatus.Text = "Request failed!";
                btEvaluate.IsEnabled = true;
            }
            wbDisplay.NavigateToString(this.mySoftwareUnderTest.tracimTestMessageAsString);
        }


        private void Button_RequestData_Click(object sender, RoutedEventArgs e)
        {
            //Get the Test-Data
            txtStatus.Text = "Waiting for data ...";
            System.Threading.Thread.Sleep(100);
 
            this.mySoftwareUnderTest.getTest().Wait();

            btSubmitResults.IsEnabled = false;
            if (this.mySoftwareUnderTest.success)
            {
                tbProcessID.Text = this.mySoftwareUnderTest.tracimTestMessage.process.key;
                tbActualXML.Text = "Requested test data";
                txtStatus.Text = "Request successful.";
                this.btEvaluate.IsEnabled = true;
                this.btEvaluate.Focus();
                this.modeCheckBox.IsChecked = false; 
                //this.mySoftwareUnderTest.loadFreeData = false;
            }
            else
            {
                tbActualXML.Text = "Request failed with the following message ...";
                txtStatus.Text = "Request failed!";
                btEvaluate.IsEnabled = true;
            }
            wbDisplay.NavigateToString(this.mySoftwareUnderTest.tracimTestMessageAsString);
        }


        private void Button_EvaluateResults_Click(object sender, RoutedEventArgs e)
        {
            txtStatus.Text = "Calculating results ...";
            System.Threading.Thread.Sleep(100);

            if (this.mySoftwareUnderTest.EvaluateResults())
            {
                if (this.mySoftwareUnderTest.loadFreeData )
                    tbActualXML.Text = "Results for free test";
                else
                    tbActualXML.Text = "Results calculated by software under test";
    
                txtStatus.Text = "Import successful.";
                this.btSubmitResults.IsEnabled = true;
                this.btSubmitResults.Focus();
            }
            else
            {
                tbActualXML.Text = "Evaluation failed with the following message ...";
                txtStatus.Text = "Import failed!";
                btSubmitResults.IsEnabled = false;
            }
            wbDisplay.NavigateToString(this.mySoftwareUnderTest.tracimResultAsXMLString);
        }

        private void Button_SubmitResults_Click(object sender, RoutedEventArgs e)
        {
            txtStatus.Text = "Submitting results ...";
            System.Threading.Thread.Sleep(100);

            this.mySoftwareUnderTest.postResults().Wait();
            if (this.mySoftwareUnderTest.success)
            {
                tbActualXML.Text = "Test result (success)";
                txtStatus.Text = "Test successful.";
            }
            else
            {
                tbActualXML.Text = "Test result (failed)";
                txtStatus.Text = "Test failed!";
            }
            wbDisplay.NavigateToString(this.mySoftwareUnderTest.tracimValidationMessageAsString);

        }


        private void Button_Close_Click(object sender, RoutedEventArgs e)
        {
            Close();
        }

        private void Infolink_RequestNavigate(object sender, RequestNavigateEventArgs e)
        {
            try
            {
 
                System.Diagnostics.Process.Start(new System.Diagnostics.ProcessStartInfo(e.Uri.AbsoluteUri));
                e.Handled = true;
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.Print(ex.Message);
            }
        }



    }
}
